﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint.Client;
using System.IO;

namespace DownloadDocument
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");
         List documentsList = ctx.Web.Lists.GetByTitle("Dokumente");

         CamlQuery camlQuery = new CamlQuery()
         {
            ViewXml =
            @"<View>
                <Query>
                  <Where>
                    <Eq>
                      <FieldRef Name='FileLeafRef'/>
                      <Value Type='Text'>temp.txt</Value>
                    </Eq>
                  </Where>
                  <RowLimit>1</RowLimit>
                </Query>
              </View>"
         };

         ListItemCollection items = documentsList.GetItems(camlQuery);
         ctx.Load(documentsList);
         ctx.Load(items);
         ctx.ExecuteQuery();

         if (items.Count == 1)
         {
            ListItem item = items[0];

            Console.WriteLine("Dateiname: {0}", item["FileLeafRef"]);
            Console.WriteLine("Pfad: {0}", item["FileDirRef"]);
            Console.WriteLine("Pfad vollständig: {0}", item["FileRef"]);
            Console.WriteLine("Dateityp: {0}\n", item["File_x0020_Type"]);

            FileInformation fileInfo =
                Microsoft.SharePoint.Client.File.OpenBinaryDirect(
                ctx, item["FileRef"].ToString());

            // Neuen Stream aufbauen und Datei lokal abspeichern
            using (FileStream stream = new FileStream(@"C:\temp.txt",
                FileMode.Create, FileAccess.Write))
            {
               byte[] buffer = new byte[51200];

               int bytesRead;

               do
               {
                  bytesRead = fileInfo.Stream.Read(buffer, 0, buffer.Length);
                  stream.Write(buffer, 0, bytesRead);
               } while (bytesRead != 0);

               Console.WriteLine("Dokument heruntergeladen!");
            }           
         }
         else
            Console.WriteLine("Kein Dokument gefunden!");
      }

   }
}
